#ifndef _PACKINGDLG_CPP
#define _PACKINGDLG_CPP
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#include <Windows.H>
#include <Stdio.H>
#include <ShlOBJ.H>
#include <Stdlib.H>

#include "../Resources/Resource.H"

#include "../Source/NSWFL.H"
#include "../Source/Package.H"
#include "../Source/Entry.H"

#include "../Dialogs/MainDlg.H"
#include "../Dialogs/OpenPassDlg.H"

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

//---------------------(Variable Declarations)
HWND PackingDialog_hWnd = NULL;
HWND PackingStatusText_hWnd = NULL;
HWND PackingActionText_hWnd = NULL;
HWND PackingStatusBar_hWnd = NULL;
HWND PackingMulButton_hWnd = NULL;

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

BOOL CALLBACK PackingDialog(HWND xHandle, UINT xMessage, WPARAM wParam, LPARAM lParam)
{
    //--------------------------------------------------------------------------

    static HMENU SystemMenu = NULL;
    static HWND Animation_hWnd = NULL;
    static HWND AVIFrame_hWnd = NULL;

    //--------------------------------------------------------------------------

    if(xMessage == WM_INITDIALOG) // Received A Initilize Dialog Message
    {
        PackingDialog_hWnd = xHandle;

        SystemMenu = GetSystemMenu(xHandle, FALSE);
        AppendMenu(SystemMenu, MF_SEPARATOR, 0, 0);
        AppendMenu(SystemMenu, MF_STRING, 1000, "About");

        SendMessage(xHandle, (UINT)WM_SETTEXT, (WPARAM)0, (LPARAM)gsTitleCaption);
        SendMessage(xHandle, WM_SETICON, TRUE, (LPARAM) LoadIcon(ghAppInstance, MAKEINTRESOURCE(IDI_MAIN)) );

        AVIFrame_hWnd          = GetDlgItem(xHandle, IDC_AVIFRAME);
        PackingActionText_hWnd = GetDlgItem(xHandle, IDC_ACTION);
        PackingMulButton_hWnd  = GetDlgItem(xHandle, IDC_MULBUTTON);
        PackingStatusBar_hWnd  = GetDlgItem(xHandle, IDC_PROGRESS);
        PackingStatusText_hWnd = GetDlgItem(xHandle, IDC_STATUSTEXT);

        Animation_hWnd = Animate_Create(AVIFrame_hWnd, 100, WS_CHILD|ACS_TRANSPARENT|ACS_AUTOPLAY, ghAppInstance);

        if(gdwCurrentJobType == JOB_TYPE_PACKING_DIR || gdwCurrentJobType == JOB_TYPE_PACKING_FIL)
        {
            Animate_Open(Animation_hWnd, MAKEINTRESOURCE(IDR_ENCRYPTAVI));
        }
        else{
            Animate_Open(Animation_hWnd, MAKEINTRESOURCE(IDR_DECRYPTAVI));
        }

        ShowWindow(Animation_hWnd, SW_SHOW);

        SendMessage(PackingStatusBar_hWnd, PBM_SETPOS, 0, (LPARAM) 0);

        CenterWindow(xHandle);

        ResumeThread(hWorker_Thread_Handle);

        SetTimer(xHandle, 0, 100, NULL);

        return TRUE; // Return TRUE to set the keyboard focus, Otherwise return FALSE
    }

    //--------------------------------------------------------------------------

    if(xMessage == WM_TIMER)
    {
        SendMessage(PackingStatusBar_hWnd, PBM_SETPOS, dwPackageProgress, (LPARAM) 0);
        return FALSE;
    }

    //--------------------------------------------------------------------------

    if(xMessage == WM_COMMAND)
    {
        if(wParam == IDC_MULBUTTON)
        {
            EnableWindow(PackingMulButton_hWnd, FALSE);
            Set_Text(PackingStatusText_hWnd, "Please wait... Cancelling.");
            gdwCurrentJobType = JOB_TYPE_CANCEL;
            return TRUE;
        }

        return FALSE;
    }

    //--------------------------------------------------------------------------

	if(xMessage == WM_PAINT)
    {
        HDC ThisHDC;
        PAINTSTRUCT ThisPS;

        ThisHDC = BeginPaint(xHandle, &ThisPS);

        // Any painting should be done here

        EndPaint(xHandle, &ThisPS);
        return TRUE;
    }

    //--------------------------------------------------------------------------

    if(xMessage == WM_SYSCOMMAND) // Received A System Menu Message
    {
        if(LOWORD(wParam) == 1000) //- About (SysMenu Command)
        {
            _AboutDialogInfo ADI;
    
            ADI.DisplayIcon  = LoadIcon(ghAppInstance, MAKEINTRESOURCE(IDI_MAIN));
            ADI.TitleCaption = gsTitleCaption;
            ADI.FileVersion  = gsFileVersion;
            ADI.BuildDate    = __DATE__;
            ADI.BuildTime    = __TIME__;
            ADI.CopyRight    = gsAppCopyRight;
            ADI.OwnerHandle  = xHandle;

            NetLogo(&ADI);
            return TRUE;
        }

        return FALSE;
    }

    //--------------------------------------------------------------------------

    if(xMessage == WM_CLOSE)  // Received Close Message
    {
        gdwCurrentJobType = JOB_TYPE_CANCEL;
        EndDialog(xHandle, 0);
        DestroyWindow(xHandle);
        return TRUE;
    }

    //--------------------------------------------------------------------------

    return FALSE;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
#endif

